# Pacotes utilizados
import math




    # Definindo valor das constantes

    h = 6.626 * 10 ** (-22) # constante de Planck dada em microns^2 kg/s
    c = 2.998 * 10 ** 14    # constante c (velocidade da luz no vácuo) dada em microns/s
    k = 1.381 * 10 ** (-11) # constante de Boltzmann dada em (microns^2 kg)/(s K)

########################################################################################################

def corponegro(comp_onda, T, h, c, k):
    ''' Essa função calcula a função de corpo negro B dados o comprimento
        de onda comp_onda, a temperatura T, constante de Planck h, constante
        c (velocidade da luz no vácuo) e constante de Boltzmann k.
    '''

    # Definindo o divisor da equação
    
    expoente = (h * c / comp_onda * k * T) - 1
    divisor = comp_onda**5 * math.exp(expoente) # math.exp calcula a exponencial da variável expoente

    # Calculando e retornando o valor de B

    B = (2 * h * c**2) / divisor

    return B

########################################################################################################

def funcao_indicedecor(indice1, indice2, Tef, Tpoeira, Re, Ri, a, n, h, c, k):
    '''Esta função calcula a função f(n) que relaciona algum índice de cor
       observado (indice1 - indice2) de uma estrela com seu raio R, sua
       temperatura efetiva Tef, o raio externo Re e interno Ri de um
       envoltório esférico de poeira, o raio a, densidade numérica n e
       temperatura Tpoeira dos grãos deste envoltório.
       h, c e k são as constantes de Planck, da velocidade da luz no vácuo
       e de Boltzmann, utilizadas na função corponegro_lambda.
    '''

    # Calculando as funções de corpo negro utilizadas em f(n)

    B1_ef = corponegro_lambda(indice1, Tef, h, c, k)
    B1_poeira = corponegro_lambda(indice1, Tpoeira, h, c, k)
    B2_ef = corponegro_lambda(indice2, Tef, h, c, k)
    B2_poeira = corponegro_lambda(indice2, Tpoeira, h, c, k)

    # Calculando partes de f(n)

    produto = (4 * pi() * a**2 / 3)(Re**3 - Ri**3)

    dividendo = R**2 * B1_ef + produto * B1_poeira * n
    divisor = R**2 * B2_ef + produto * B2_poeira * n

    divisao = dividendo / divisor

    # Calculando f(n):

    f_n = (indice1 - indice2) + 2,5 * math.log10(divisao)
    
    return f_n
    
#########################################################################################################

def achazero_dicotomia(funcao, A, B, precisao, indice1, indice2, Tef, Tpoeira, Re, Ri, a, n, h, c, k):
    '''Esta função encontra o blablabla
    '''

    # Determinando a condição em que o laço while deverá parar
    
    limite = 2 * precisao
    
    # Laço que encontra as raízes de f(n) pelo método da dicotomia
    
    while abs(B - A) < limite:

        f_a = funcao_indicedecor(indice1, indice2, Tef, Tpoeira, Re, Ri, a, A, h, c, k)
        f_b = funcao_indicedecor(indice1, indice2, Tef, Tpoeira, Re, Ri, a, B, h, c, k)
    
        x_medio = (B - A) / 2
    
        f_xm = funcao_indicedecor(indice1, indice2, Tef, Tpoeira, Re, Ri, a, x_medio, h, c, k)

        if f_a * f_xm > 0:
            A = x_medio
            
        else:
            B = x_medio







